<?php
// CHECK: Kya ye file direct kholi gayi hai?
$is_direct = (basename($_SERVER['PHP_SELF']) == 'admission_form.php');

// Agar direct hai to Header include karein
if ($is_direct) {
    include 'header.php';
}
?>

<style>
    /* --- SHARED FORM STYLES --- */
    .form-header h2 { margin: 0 0 10px; color: #0B2447; font-family: 'Montserrat', sans-serif; }
    .form-header p { margin: 0 0 20px; color: #666; font-size: 14px; }
    
    .input-group { margin-bottom: 15px; }
    .input-group label {
        display: block; font-size: 12px; font-weight: 600; color: #0B2447;
        margin-bottom: 5px; text-transform: uppercase; letter-spacing: 0.5px;
    }
    .input-group input, .input-group select {
        width: 100%; padding: 12px;
        border: 2px solid #eee; border-radius: 6px;
        font-size: 14px; font-family: 'Poppins', sans-serif; background: #fafafa;
        transition: 0.3s;
    }
    .input-group input:focus, .input-group select:focus {
        border-color: #FF8C00; background: #fff; outline: none;
    }
    .submit-btn {
        width: 100%; padding: 14px; margin-top: 10px;
        background: #0B2447; color: white;
        border: none; border-radius: 6px;
        font-size: 16px; font-weight: 700; cursor: pointer;
        transition: 0.3s; text-transform: uppercase; letter-spacing: 1px;
    }
    .submit-btn:hover { background: #FF8C00; box-shadow: 0 5px 15px rgba(255, 140, 0, 0.4); }

    /* --- POPUP SPECIFIC STYLES (Modal) --- */
    .modal {
        display: none; position: fixed; z-index: 10000;
        left: 0; top: 0; width: 100%; height: 100%;
        overflow: auto; background-color: rgba(0, 0, 0, 0.7);
        backdrop-filter: blur(4px);
    }
    .modal-content {
        background-color: #fff; margin: 4% auto;
        width: 90%; max-width: 850px;
        border-radius: 12px; box-shadow: 0 15px 40px rgba(0,0,0,0.4);
        display: flex; overflow: hidden; animation: slideUp 0.4s ease-out;
    }
    @keyframes slideUp { from {transform: translateY(50px); opacity: 0;} to {transform: translateY(0); opacity: 1;} }
    
    .modal-image-side {
        width: 45%;
        background-image: url('https://images.unsplash.com/photo-1554224155-8d04cb21cd6c?q=80&w=600&auto=format&fit=crop');
        background-size: cover; background-position: center; position: relative;
        display: flex; flex-direction: column; justify-content: flex-end; padding: 30px;
    }
    .modal-image-side::before {
        content: ""; position: absolute; top: 0; left: 0; right: 0; bottom: 0;
        background: linear-gradient(to bottom, rgba(11,36,71,0.3), rgba(11,36,71,0.9));
    }
    .image-text { position: relative; color: white; z-index: 2; }
    .image-text h3 { margin: 0; font-size: 24px; font-weight: 700; color: #D4AF37; }
    .image-text p { margin: 5px 0 0; font-size: 13px; opacity: 0.9; }
    .modal-form-side { width: 55%; padding: 40px; position: relative; }
    .close-btn {
        position: absolute; top: 15px; right: 20px;
        color: #aaa; font-size: 28px; font-weight: bold; cursor: pointer; transition: 0.2s;
    }
    .close-btn:hover { color: #000; }

    /* --- DIRECT PAGE SPECIFIC STYLES --- */
    .contact-page-section { padding: 60px 10%; background: #f9f9f9; }
    .contact-grid { display: flex; gap: 40px; flex-wrap: wrap; }
    .contact-info-box {
        flex: 1; min-width: 300px;
        background: white; padding: 40px;
        border-radius: 10px; box-shadow: 0 5px 20px rgba(0,0,0,0.05);
    }
    .contact-form-box {
        flex: 1.2; min-width: 300px;
        background: white; padding: 40px;
        border-radius: 10px; box-shadow: 0 5px 20px rgba(0,0,0,0.05);
        border-top: 5px solid #FF8C00;
    }
    .info-item { margin-bottom: 25px; border-bottom: 1px solid #eee; padding-bottom: 15px; }
    .info-item:last-child { border-bottom: none; }
    .info-item h4 { color: #0B2447; margin-bottom: 5px; display: flex; align-items: center; gap: 10px; }
    .info-item p { color: #555; margin: 0; font-size: 14px; line-height: 1.6; }
    .info-item a { color: #FF8C00; text-decoration: none; font-weight: 600; }

    @media (max-width: 768px) {
        .modal-content { flex-direction: column; width: 95%; margin: 15% auto; }
        .modal-image-side { display: none; }
        .modal-form-side { width: 100%; padding: 25px; }
        .contact-page-section { padding: 40px 5%; }
    }
</style>

<?php if ($is_direct): ?>

    <section class="hero" style="min-height: 40vh; display: flex; flex-direction: column; justify-content: center; align-items: center; text-align: center; color: white; background-image: linear-gradient(rgba(11, 36, 71, 0.85), rgba(11, 36, 71, 0.85)), url('https://images.unsplash.com/photo-1554224155-8d04cb21cd6c?q=80&w=1600&auto=format&fit=crop'); background-size: cover; background-position: center;">
        <h1 style="font-size: 42px; margin-bottom: 10px; font-family: 'Montserrat', sans-serif;">Get In Touch</h1>
        <p class="sub-hero" style="font-size: 18px; letter-spacing: 1px; color: #FF8C00;">ADMISSION ENQUIRY & SUPPORT</p>
    </section>

    <section class="contact-page-section">
        <div class="contact-grid">
            <div class="contact-info-box">
                <h2 style="color: #0B2447; margin-bottom: 15px;">Contact Information</h2>
                <p style="color: #666; margin-bottom: 30px;">We would be happy to guide you and answer your queries.</p>
                <div class="info-item"><h4>📍 Address</h4><p>Jahazpur & Deoli Campus</p></div>
                <div class="info-item"><h4>📞 Phone</h4><p><a href="tel:9660061263">+91 9660061263</a></p></div>
                <div class="info-item"><h4>📧 Email</h4><p>contact@zenithschools.in</p></div>
            </div>

            <div class="contact-form-box">
                <div class="form-header">
                    <h2>Admission Enquiry</h2>
                    <p>Fill the form below to request a callback.</p>
                </div>
                <form action="send_enquiry.php" method="POST">
                    <div class="input-group"><label>Parent's Name</label><input type="text" name="parent_name" required></div>
                    <div class="input-group"><label>Child's Name</label><input type="text" name="child_name" required></div>
                    <div style="display: flex; gap: 15px;">
                        <div class="input-group" style="flex: 1;"><label>Mobile</label><input type="tel" name="mobile" required></div>
                        <div class="input-group" style="flex: 1;"><label>Email</label><input type="email" name="email"></div>
                    </div>
                    <div style="display: flex; gap: 15px;">
                        <div class="input-group" style="flex: 1;"><label>Class</label><select name="class_grade"><option>Nursery</option><option>1-5</option><option>6-8</option><option>9-12</option></select></div>
                        <div class="input-group" style="flex: 1;"><label>Branch</label><select name="branch"><option>Jahazpur</option></select></div>
                    </div>
                    <button type="submit" class="submit-btn">Send Enquiry</button>
                </form>
            </div>
        </div>
    </section>

<?php else: ?>

<div id="admissionModal" class="modal">
    <div class="modal-content">
        <div class="modal-image-side">
            <div class="image-text">
                <h3>Start Their Journey</h3>
                <p>Join the Zenith family.</p>
            </div>
        </div>
        <div class="modal-form-side">
            <span class="close-btn">&times;</span>
            <div class="form-header">
                <h2>Enquire Now</h2>
                <p>Fill details for a callback.</p>
            </div>
            <form action="send_enquiry.php" method="POST">
                <div class="input-group"><label>Parent's Name</label><input type="text" name="parent_name" required></div>
                <div class="input-group"><label>Child's Name</label><input type="text" name="child_name" required></div>
                <div style="display: flex; gap: 15px;">
                    <div class="input-group" style="flex: 1;"><label>Mobile</label><input type="tel" name="mobile" required></div>
                    <div class="input-group" style="flex: 1;"><label>Email</label><input type="email" name="email"></div>
                </div>
                <div style="display: flex; gap: 15px;">
                    <div class="input-group" style="flex: 1;"><label>Class</label><select name="class_grade"><option>Nursery</option><option>1-5</option><option>6-8</option><option>9-12</option></select></div>
                    <div class="input-group" style="flex: 1;"><label>Branch</label><select name="branch"><option>Jahazpur</option></select></div>
                </div>
                <button type="submit" class="submit-btn">Submit Enquiry</button>
            </form>
        </div>
    </div>
</div>

<?php endif; ?>

<?php
if ($is_direct) {
    include 'footer.php';
}
?>