<?php
// --- EMAIL LOGIC (YE SABSE UPAR HI RAHEGA) ---
if (isset($_POST['submit_enquiry'])) {
    
    // 1. Data Receive
    $parent_name = htmlspecialchars($_POST['parent_name']);
    $student_name = htmlspecialchars($_POST['student_name']);
    $phone = htmlspecialchars($_POST['phone']);
    $class = htmlspecialchars($_POST['class']);
    $message = htmlspecialchars($_POST['message']);

    // 2. Email Settings
    $my_email = "contact@ryzenia.com"; 
    $to = "354nitesh@gmail.com"; 
    $subject = "New Admission Enquiry - Ryzenia School";

    // 3. Email Body
    $email_content = "
    <h2>New Admission Enquiry</h2>
    <p><strong>Parent Name:</strong> $parent_name</p>
    <p><strong>Student Name:</strong> $student_name</p>
    <p><strong>Phone:</strong> $phone</p>
    <p><strong>Class:</strong> $class</p>
    <p><strong>Message:</strong><br>$message</p>
    ";

    // 4. Headers
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= "From: " . $my_email . "\r\n"; 

    // 5. Send Mail
    if(mail($to, $subject, $email_content, $headers)) {
        echo "<script>alert('✅ Success! Your enquiry has been sent successfully.'); window.location.href='contact.php';</script>";
    } else {
        echo "<script>alert('❌ Error! Mail could not be sent. Please try again.'); window.history.back();</script>";
    }
}
?>

<?php include 'header.php'; ?>

    <section class="hero" style="min-height: 40vh; background-image: linear-gradient(rgba(11, 36, 71, 0.8), rgba(11, 36, 71, 0.7)), url('https://images.unsplash.com/photo-1523050854058-8df90110c9f1?q=80&w=1600&auto=format&fit=crop');">
        <h1>Get In Touch</h1>
        <p class="sub-hero">We'd love to hear from you</p>
    </section>

    <section class="contact-container">
        
        <div class="contact-info">
            <h2>Contact Information</h2>
            <p>We would be happy to guide you and answer your queries. Visit us or call us today.</p>
            
            <div class="info-item">
                <h4>📍 Address</h4>
                <p>Near Chawandiya Circle, Shahpura Bypass Road, Jahazpur, Bhilwara, Rajasthan, 311201</p>
            </div>
            <div class="info-item">
                <h4>📞 Phone</h4>
                <p><a href="tel:9660061263">9660061263</a></p>
            </div>
            <div class="info-item">
                <h4>📧 Email</h4>
               <p>
                <a href="mailto:contact@<?php echo str_replace('www.', '', $_SERVER['HTTP_HOST']); ?>">
                    contact@<?php echo str_replace('www.', '', $_SERVER['HTTP_HOST']); ?>
                </a>
            </p>
            </div>
            
            <div style="margin-top: 20px; width: 100%; height: 250px; background: #eee; border-radius: 10px; border: 2px solid var(--gold); overflow: hidden;">
                <iframe 
                    width="100%" 
                    height="100%" 
                    style="border:0;" 
                    loading="lazy" 
                    allowfullscreen 
                    referrerpolicy="no-referrer-when-downgrade"
                    src="https://www.google.com/maps?q=Jahazpur+Bhilwara+Rajasthan&output=embed">
                </iframe>
            </div>
        </div>

        <div class="contact-form-box">
            <h2>Send Us a Message</h2>
            
            <form method="POST" action="">
                <div class="form-group">
                    <label>Parent's Name</label>
                    <input type="text" name="parent_name" placeholder="Enter your name" required>
                </div>
                <div class="form-group">
                    <label>Student's Name</label>
                    <input type="text" name="student_name" placeholder="Enter student's name" required>
                </div>
                <div class="form-group">
                    <label>Phone Number</label>
                    <input type="tel" name="phone" placeholder="Your mobile number" required>
                </div>
                <div class="form-group">
                    <label>Class for Admission</label>
                    <select name="class">
                        <option>Select Class</option>
                        <option>Playgroup / Nursery</option>
                        <option>Primary (1st - 5th)</option>
                        <option>Middle (6th - 8th)</option>
                        <option>Secondary (9th - 10th)</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>Message / Query</label>
                    <textarea name="message" rows="4" placeholder="Any specific questions?"></textarea>
                </div>
                
                <button type="submit" name="submit_enquiry" class="submit-btn">Send Enquiry</button>
            </form>
        </div>
    </section>

<?php include 'footer.php'; ?>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const hamburger = document.getElementById('hamburger-btn');
        const navMenu = document.getElementById('nav-menu');
        const navLinks = document.querySelectorAll('#nav-menu a');

        // Toggle Menu
        hamburger.addEventListener('click', function() {
            hamburger.classList.toggle('active');
            navMenu.classList.toggle('active');
        });

        // Close Menu on Link Click
        navLinks.forEach(function(link) {
            link.addEventListener('click', function() {
                hamburger.classList.remove('active');
                navMenu.classList.remove('active');
            });
        });
    });
</script>

</body>
</html>