<?php include 'header.php'; ?>

    <section class="hero" id="home">
        <h1>Rising Towards Excellence</h1>
        <p class="sub-hero">AI • Robotics • Model-Based Learning</p>
        <p class="hero-desc">
            Zenith Group Of Schools is a future-ready institution combining strong academics with hands-on, experiential education. We help students think critically, innovate creatively, and succeed confidently.
        </p>
        <a href="contact.php" class="btn-primary">Enquire Now</a>
    </section>

    <section class="why-section" id="life-at-Zenith" style="background: var(--white); border-top: 5px solid var(--navy); border-bottom: none;">
        <h2 style="color: var(--navy);">Beyond Academics</h2>
        <p style="color: #666; margin-bottom: 40px; letter-spacing: 1px;">DEVELOPING SKILLS FOR A LIFETIME</p>
        
        <div class="why-grid">
            <div class="why-card" style="background: var(--navy); border:none;">
                <span class="icon">🗣️</span>
                <h4 style="color: var(--white);">Public Speaking</h4>
                <p style="color: #ccc;">Debates & Confidence Building.</p>
            </div>
            <div class="why-card" style="background: var(--navy); border:none;">
                <span class="icon">⚙️</span>
    
                <h4 style="color: var(--white);">Hands-On Learning</h4>
    
                <p style="color: #ccc;">Experiential learning in labs & workshops.</p>
            </div>
            <div class="why-card" style="background: var(--navy); border:none;">
                <span class="icon">🎨</span>
                <h4 style="color: var(--white);">Creative Arts</h4>
                <p style="color: #ccc;">Music, Dance & Painting.</p>
            </div>

            <div class="why-card" style="background: var(--navy); border:none;">
                <span class="icon">⚽</span>
                <h4 style="color: var(--white);">Sports</h4>
                <p style="color: #ccc;">Fitness, Yoga & Teamwork.</p>
            </div>

        </div>
    </section>

    <section class="about-section" id="about">
        <div class="about-text">
            <span class="highlight-text">Who We Are</span>
            <h2>Future-Ready Education</h2>
            <p>
                <strong>Zenith Group Of Schools</strong> is committed to nurturing young minds by balancing modern technology with essential life skills. We believe education is not just about textbooks, but about building confidence by public speking, creativity, and character.
            </p>
            
            <h3 style="font-size: 20px; color: var(--orange); margin-top: 20px;">Our Vision</h3>
            <p>To create a learning environment where students excel in <strong>not just Academics, but in Innovation, and Life Skills</strong>, truly rising towards excellence.</p>

            <ul class="feature-list">
                <li><strong>Tech-Driven:</strong> AI, Robotics & Model Making Labs</li>
                <li><strong>Skill-Based:</strong> Public Speaking & Leadership</li>
                <li><strong>Holistic Growth:</strong> Integrated Sports & Arts</li>
            </ul>
            <br>
            <a href="about.php" class="btn-primary" style="margin-top: 10px;">Read More About Us</a>
        </div>
        <div class="about-image">
            <img src="https://images.unsplash.com/photo-1434030216411-0b793f4b4173?q=80&w=800&auto=format&fit=crop" alt="Zenith Student Studying" style="box-shadow: 15px 15px 0 var(--navy); border-radius: 10px;">
        </div>
    </section>

    <section class="chairman-section" style="background: #fafafa; color: var(--navy); border-top: 4px solid var(--gold); padding: 80px 10%;">
        <div style="text-align: center; margin-bottom: 50px;">
            <span class="highlight-text">Guided by Experts</span>
            <h2 style="color: var(--navy);">Meet Our Leadership</h2>
            <p style="color: #555;">Led by IIT Bombay Alumni & Experienced Educators</p>
        </div>

        <div style="display: flex; gap: 40px; flex-wrap: wrap; justify-content: center;">
            
            <div style="flex: 1; min-width: 300px; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 10px 30px rgba(0,0,0,0.08); text-align: center; border-top: 5px solid var(--navy);">
                <img src="https://images.unsplash.com/photo-1560250097-0b93528c311a?q=80&w=200&h=200&auto=format&fit=crop" style="width: 120px; height: 120px; border-radius: 50%; margin: 0 auto 20px auto; border: 3px solid var(--gold);" alt="Director">
                <h3 style="margin-bottom: 5px;">Mr. Nitesh Meena</h3>
                <p style="color: var(--orange); font-weight: 700; font-size: 12px; letter-spacing: 1px; margin-bottom: 10px;">FOUNDER & DIRECTOR</p>
                <p style="background: #eee; display: inline-block; padding: 5px 15px; border-radius: 20px; font-size: 13px; font-weight: 600; margin-bottom: 20px;">
                    🎓 B.Tech (Chem. Engg), IIT Bombay
                </p>
                <p style="font-size: 14px; color: #555;">"We are bringing world-class technical education to Jahazpur(Bhilwara). Innovation starts here."</p>
            </div>

            <!--div style="flex: 1; min-width: 300px; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 10px 30px rgba(0,0,0,0.08); text-align: center; border-top: 5px solid var(--orange);">
                <img src="https://images.unsplash.com/photo-1573496359142-b8d87734a5a2?q=80&w=200&h=200&auto=format&fit=crop" style="width: 120px; height: 120px; border-radius: 50%; margin: 0 auto 20px auto; border: 3px solid var(--navy);" alt="Principal">
                <h3 style="margin-bottom: 5px;">Neeraj Kumar</h3>
                <p style="color: var(--orange); font-weight: 700; font-size: 12px; letter-spacing: 1px; margin-bottom: 10px;">PRINCIPAL</p>
                <p style="background: #eee; display: inline-block; padding: 5px 15px; border-radius: 20px; font-size: 13px; font-weight: 600; margin-bottom: 20px;">
                    🎓 B.Sc. (PCM), JNU Jaipur
                </p>
                <p style="font-size: 14px; color: #555;">"Fostering a strong foundation in Science & Mathematics for a bright future."</p>
            </div-->

        </div>
    </section>

    <section class="about-section" id="labs" style="background-color: var(--navy); flex-direction: row-reverse; color: white;">
        <div class="about-text">
            <span class="highlight-text" style="color: var(--gold);">Innovation Hub</span>
            <h2 style="color: white;">AI, Robotics & Model Making Lab</h2>
            <p style="color: #ddd;">Our lab is the heart of innovation. We support hands-on learning, enabling students to understand concepts deeply rather than learning them theoretically.</p>
            
            <div style="display: flex; gap: 20px; flex-wrap: wrap; margin-top: 20px;">
                <div style="flex: 1; min-width: 200px; background: rgba(255,255,255,0.1); padding: 15px; border-radius: 8px; border: 1px solid rgba(255,255,255,0.2);">
                    <h4 style="color:var(--gold); margin-bottom: 5px;">🤖 AI & Robotics</h4>
                    <small style="color: #ccc;">Logic, Coding</small>
                </div>
                <div style="flex: 1; min-width: 200px; background: rgba(255,255,255,0.1); padding: 15px; border-radius: 8px; border: 1px solid rgba(255,255,255,0.2);">
                    <h4 style="color:var(--orange); margin-bottom: 5px;">⚙️ Model Making</h4>
                    <small style="color: #ccc;">Prototyping & STEM Projects</small>
                </div>
            </div>
            
            <br>
            <a href="labs.php" class="btn-primary" style="background: var(--white); color: var(--navy);">Explore Our Labs</a>
        </div>
        <div class="about-image">
            <img src="https://images.unsplash.com/photo-1581092918056-0c4c3acd3789?q=80&w=800&auto=format&fit=crop" alt="AI Lab" style="border-color: var(--gold); box-shadow: -15px 15px 0 rgba(255,255,255,0.1);">
        </div>
    </section>

     <section class="why-section" id="why-us">
        <h2 style="color: var(--white);">Why Choose Zenith?</h2>
        <p style="color: var(--gold); letter-spacing: 1px; margin-bottom: 40px;">RISING TOWARDS EXCELLENCE</p>
        
        <div class="why-grid">
            <div class="why-card">
                <span class="icon">🤖</span>
                <h4>AI & Robotics</h4>
                <p>Focused curriculum for future tech.</p>
            </div>

            <div class="why-card">
                <span class="icon">🧠</span>
                <h4>Model-Based</h4>
                <p>Experiential learning approach.</p>
            </div>

            <div class="why-card">
                <span class="icon">🏫</span>
                <h4>Modern Infra</h4>
                <p>High-tech innovation labs.</p>
            </div>

            <div class="why-card">
                <span class="icon">🛡️</span>
                <h4>Safe Campus</h4>
                <p>Supportive & inspiring environment.</p>
            </div>

            <div class="why-card">
                <span class="icon">⭐</span>
                <h4>Excellence</h4>
                <p>Commitment to future readiness.</p>
            </div>
        </div>
    </section>

   <?php include 'footer.php'; ?>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const hamburger = document.getElementById('hamburger-btn');
        const navMenu = document.getElementById('nav-menu');
        const navLinks = document.querySelectorAll('#nav-menu a');

        // 1. Toggle Menu on Click
        hamburger.addEventListener('click', function() {
            hamburger.classList.toggle('active');
            navMenu.classList.toggle('active');
        });

        // 2. Close Menu when clicking any link
        navLinks.forEach(function(link) {
            link.addEventListener('click', function() {
                hamburger.classList.remove('active');
                navMenu.classList.remove('active');
            });
        });
    });
</script>
</body>
</html>