<?php include 'header.php'; ?>

<style>
    .principal-section { display: flex; gap: 50px; align-items: center; padding: 80px 10%; background: white; }
    .principal-img-box { flex: 1; position: relative; }
    .principal-img-box img { width: 100%; border-radius: 10px; box-shadow: 20px 20px 0 #0B2447; }
    .principal-text { flex: 1.5; }
    .facilities-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 30px; padding: 60px 10%; background: #fafafa; }
    .facility-card { background: white; padding: 30px; border-radius: 10px; text-align: center; box-shadow: 0 5px 20px rgba(0,0,0,0.05); transition: 0.3s; border-bottom: 4px solid #0B2447; }
    .facility-card:hover { transform: translateY(-10px); }
    .facility-icon { font-size: 40px; margin-bottom: 20px; display: block; }
    .branch-contact { background: #0B2447; color: white; padding: 80px 10%; display: flex; flex-wrap: wrap; gap: 40px; }
    .contact-details { flex: 1; }
    .contact-map { flex: 1; min-width: 300px; height: 350px; border-radius: 10px; overflow: hidden; border: 2px solid #F1C40F; }
    @media (max-width: 768px) {
        .principal-section { flex-direction: column; text-align: center; }
        .branch-contact { flex-direction: column; }
        .principal-img-box img { box-shadow: 10px 10px 0 #0B2447; }
    }
</style>

<section class="hero" style="min-height: 60vh; display: flex; flex-direction: column; justify-content: center; align-items: center; text-align: center; color: white; background-image: linear-gradient(rgba(11, 36, 71, 0.7), rgba(11, 36, 71, 0.7)), url('https://images.unsplash.com/photo-1580582932707-520aed937b7b?q=80&w=1600&auto=format&fit=crop'); background-size: cover; background-position: center;">
    <span style="background: #F1C40F; color: #0B2447; padding: 5px 15px; font-weight: 700; border-radius: 20px; font-size: 14px; letter-spacing: 1px; margin-bottom: 15px;">JAHAZPUR CAMPUS</span>
    <h1 style="font-size: 48px; margin: 0; font-family: 'Montserrat', sans-serif;">Zenith School, Jahazpur</h1>
    <p class="sub-hero" style="font-size: 18px; color: #FF8C00; letter-spacing: 1px; margin-top: 10px;">EXCELLENCE IN SPORTS & ACADEMICS</p>
</section>

<section class="principal-section">
    <div class="principal-img-box">
        <img src="https://images.unsplash.com/photo-1573496359142-b8d87734a5a2?q=80&w=600&auto=format&fit=crop" alt="Mr. R.K. Sharma">
    </div>
    <div class="principal-text">
        <span style="color: #FF8C00; font-weight: 700; letter-spacing: 1px;">LEADERSHIP</span>
        <h2 style="color: #0B2447; margin: 10px 0 20px; font-family: 'Montserrat', sans-serif;">Principal's Message</h2>
        <p style="font-size: 16px; line-height: 1.8; color: #555; margin-bottom: 25px;">
            "At Jahazpur Campus, we believe in holistic development. Along with academic excellence, we provide state-of-the-art sports facilities to ensure our students remain physically fit and disciplined."
        </p>
        
        <div style="border-left: 4px solid #FF8C00; padding-left: 15px;">
            <h3 style="margin: 0; color: #0B2447;">Mr. Neeraj Kumar</h3>
            <p style="margin: 5px 0 0; font-size: 14px; font-weight: 600; color: #777;">
                🎓 B.Sc. (PCM), JNU
            </p>
        </div>
    </div>
</section>

<section style="text-align: center; padding-top: 60px; background: #fafafa;">
    <h2 style="color: #0B2447; margin-bottom: 10px;">Campus Facilities</h2>
    <p style="color: #666;">Modern amenities at Jahazpur</p>
</section>

<div class="facilities-grid">
    <div class="facility-card">
        <span class="facility-icon">⚽</span>
        <h3>Sports Complex</h3>
        <p>Huge playground for Cricket, Football and Volleyball.</p>
    </div>
    <div class="facility-card">
        <span class="facility-icon">🧘</span>
        <h3>Yoga Center</h3>
        <p>Dedicated space for Yoga and Meditation classes.</p>
    </div>
    <div class="facility-card">
        <span class="facility-icon">🎭</span>
        <h3>Auditorium</h3>
        <p>Large hall for cultural events and competitions.</p>
    </div>
    <div class="facility-card">
        <span class="facility-icon">🔬</span>
        <h3>STEM Lab</h3>
        <p>Focus on Science, Technology, Engineering & Maths.</p>
    </div>
</div>
<style>
    /* Section Container - Dark Navy Background */
    .branch-contact-section {
        padding: 80px 10%;
        background-color: #0B2447; /* Zenith Navy Blue */
        background-image: linear-gradient(135deg, rgba(11, 36, 71, 0.95), rgba(11, 36, 71, 0.9)), url('https://www.transparenttextures.com/patterns/cubes.png');
        display: flex;
        flex-wrap: wrap;
        gap: 40px;
        align-items: stretch; /* Cards same height */
        color: white;
    }

    /* Left Side: Contact Info - Glass Effect */
    .contact-info-card {
        flex: 1;
        min-width: 300px;
        background: rgba(255, 255, 255, 0.05); /* Slight transparent white */
        padding: 40px;
        border-radius: 10px;
        border: 1px solid rgba(212, 175, 55, 0.3); /* Gold Border Light */
        box-shadow: 0 10px 30px rgba(0,0,0,0.3);
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    .contact-subtitle {
        color: #FF8C00; /* Orange Accent */
        font-size: 13px;
        font-weight: 700;
        letter-spacing: 2px;
        text-transform: uppercase;
        margin-bottom: 10px;
    }

    .contact-title {
        color: #fff;
        font-size: 32px;
        margin: 0 0 10px;
        font-family: 'Montserrat', sans-serif;
        font-weight: 700;
    }

    .contact-desc {
        color: #ccc;
        margin-bottom: 40px;
        font-size: 14px;
        line-height: 1.6;
    }

    /* Info Row Styling */
    .info-row {
        display: flex;
        gap: 20px;
        margin-bottom: 30px;
        align-items: center;
    }

    .info-icon {
        width: 50px;
        height: 50px;
        background-color: #F1C40F; /* Gold Background */
        color: #0B2447; /* Navy Icon Color */
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 50%;
        font-size: 20px;
        flex-shrink: 0;
        box-shadow: 0 0 15px rgba(212, 175, 55, 0.4);
    }

    .info-content h4 {
        margin: 0 0 3px;
        color: #F1C40F; /* Gold Text */
        font-size: 16px;
        text-transform: uppercase;
        font-weight: 700;
        letter-spacing: 0.5px;
    }

    .info-content p, .info-content a {
        margin: 0;
        color: #fff; /* White Text */
        font-size: 15px;
        text-decoration: none;
    }

    .info-content a:hover {
        color: #FF8C00;
        text-decoration: underline;
    }

    /* Right Side: Map */
    .map-container {
        flex: 1.3; /* Map thoda chauda rahega */
        min-width: 300px;
        min-height: 500px;
        border-radius: 10px;
        overflow: hidden;
        border: 2px solid #F1C40F; /* Gold Border */
        box-shadow: 0 15px 40px rgba(0,0,0,0.4);
    }

    /* Button */
    .btn-contact {
        display: inline-block;
        margin-top: 10px;
        background: #F1C40F; /* Gold Button */
        color: #0B2447; /* Navy Text */
        padding: 14px 35px;
        font-weight: 800;
        text-decoration: none;
        border-radius: 5px;
        text-transform: uppercase;
        transition: 0.3s;
        align-self: flex-start;
    }
    .btn-contact:hover {
        background: #fff;
        color: #0B2447;
        box-shadow: 0 0 20px rgba(255,255,255,0.4);
    }

    @media (max-width: 768px) {
        .branch-contact-section { padding: 50px 5%; flex-direction: column; }
        .map-container { min-height: 350px; width: 100%; }
    }
</style>

<section class="branch-contact-section">
    
    <div class="contact-info-card">
        <span class="contact-subtitle">Get In Touch</span>
        <h2 class="contact-title">Reach Us</h2>
        <p style="color: #666; margin-bottom: 30px;">
            Have questions? We are here to help. Visit our Jahazpur campus or contact us via phone or email.
        </p>

        <div class="info-row">
            <div class="info-icon">📍</div>
            <div class="info-content">
                <h4>Campus Address</h4>
                <p>Near Chawandiya Circle, Shahpura Bypass Road, Jahazpur, Bhilwara, Rajasthan, 311201</p>
            </div>
        </div>

        <div class="info-row">
            <div class="info-icon">📞</div>
            <div class="info-content">
                <h4>Phone Number</h4>
                <p>
                    <a href="tel:9950441192">+91 99504 41192</a> <br>
                    <small style="color:#888;">(Mon-Sat, 8:00 AM - 4:00 PM)</small>
                </p>
            </div>
        </div>

        <div class="info-row">
            <div class="info-icon">📧</div>
            <div class="info-content">
                <h4>Email Address</h4>
                <p>
                    <a href="mailto:jahazpur@<?php echo str_replace('www.', '', $_SERVER['HTTP_HOST']); ?>">
                        jahazpur@<?php echo str_replace('www.', '', $_SERVER['HTTP_HOST']); ?>
                    </a>
                </p>
            </div>
        </div>

        <a href="admission_form.php" class="btn-contact">Apply for Admission →</a>
    </div>

    <div class="map-container">
        <iframe 
            src="https://www.google.com/maps?q=Jahazpur+Bhilwara+Rajasthan&output=embed" 
            width="100%" 
            height="100%" 
            style="border:0;" 
            allowfullscreen="" 
            loading="lazy" 
            referrerpolicy="no-referrer-when-downgrade">
        </iframe>
    </div>

</section>

<?php include 'footer.php'; ?>