<?php include 'header.php'; ?>

    <section class="hero" style="min-height: 50vh; background-image: linear-gradient(rgba(11, 36, 71, 0.8), rgba(11, 36, 71, 0.7)), url('https://images.unsplash.com/photo-1503676260728-1c00da094a0b?q=80&w=1600&auto=format&fit=crop');">
        <h1>Our Philosophy</h1>
        <p class="sub-hero">Observe • Experiment • Learn • Apply • Innovate</p>
    </section>

    <section class="about-section">
        <div class="about-text">
            <span class="highlight-text">Core Beliefs</span>
            <h2>How We Teach</h2>
            <p>At the heart of <strong>Zenith Group of Schools</strong> lies the belief that true learning happens through experience. Our teaching approach is designed to ensure that students actively engage with concepts rather than passively receive information.</p>
        </div>
        <div class="about-image">
            <img src="https://images.unsplash.com/photo-1516321318423-f06f85e504b3?q=80&w=800&auto=format&fit=crop" alt="Learning Model">
        </div>
    </section>

    <section class="process-section">
        <div class="process-container">
            <div class="process-step">
                <div class="step-number">01</div>
                <h3>👀 OBSERVE (देखो)</h3>
                <p>Learning starts with observation using visual models, smart class demonstrations, and real-life examples.</p>
            </div>

            <div class="process-step">
                <div class="step-number">02</div>
                <h3>⚙️ EXPERIMENT (प्रयोग करो)</h3>
                <p>Hands-on activities where students touch, build, and play with Robotics kits and Science models.</p>
            </div>

            <div class="process-step">
                <div class="step-number">03</div>
                <h3>🧠 LEARN (सीखो)</h3>
                <p>Developing deep conceptual clarity and logic instead of rote memorization (रट्टा मारना).</p>
            </div>

            <div class="process-step">
                <div class="step-number">04</div>
                <h3>🛠️ APPLY (इस्तेमाल करो)</h3>
                <p>Using the learned concepts to solve real-world problems effectively.</p>
            </div>

            <div class="process-step">
                <div class="step-number">05</div>
                <h3>🚀 INNOVATE (नया बनाओ)</h3>
                <p>The final goal is not just passing exams, but creating new ideas and becoming a future leader.</p>
            </div>
        </div>
    </section>

   <?php include 'footer.php'; ?>

<script>
        // Inline script just in case script.js isn't linked
        document.addEventListener('DOMContentLoaded', function() {
            const hamburger = document.getElementById('hamburger-btn');
            const navMenu = document.getElementById('nav-menu');
            const navLinks = document.querySelectorAll('#nav-menu a');
            hamburger.addEventListener('click', function() { hamburger.classList.toggle('active'); navMenu.classList.toggle('active'); });
            navLinks.forEach(function(link) { link.addEventListener('click', function() { hamburger.classList.remove('active'); navMenu.classList.remove('active'); }); });
        });
    </script>
</body>
</html>